<?php require "../config/db.php";
if(!isset($_SESSION['admin'])) die("Access denied");
?>
<!DOCTYPE html>
<html>
<head>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">

<h3>Admin - Manage Students</h3>

<form id="studentForm" enctype="multipart/form-data">
<input name="name" class="form-control mb-2" placeholder="Name">
<input name="email" class="form-control mb-2" placeholder="Email">
<input name="mobile" class="form-control mb-2" placeholder="Mobile">
<input type="file" name="image" class="form-control mb-2">
<button class="btn btn-dark">Add Student</button>
</form>

<table class="table mt-4">
<thead><tr><th>Name</th><th>Email</th><th>Image</th><th>Action</th></tr></thead>
<tbody id="list"></tbody>
</table>

<script>
const form=document.getElementById("studentForm");

form.onsubmit=e=>{
 e.preventDefault();
 let fd=new FormData(form);
 fetch("ajax/save.php",{method:"POST",body:fd})
 .then(r=>r.json()).then(()=>{form.reset();load();});
};

function load(){
 fetch("ajax/fetch.php").then(r=>r.json()).then(d=>{
  list.innerHTML="";
  d.forEach(s=>{
   list.innerHTML+=`<tr>
   <td>${s.name}</td>
   <td>${s.email}</td>
   <td><img src="../uploads/${s.image}" width="50"></td>
   <td><button onclick="del(${s.id})" class="btn btn-danger btn-sm">Delete</button></td>
   </tr>`;
  });
 });
}

function del(id){
 fetch("ajax/delete.php",{method:"POST",headers:{'Content-Type':'application/x-www-form-urlencoded'},body:"id="+id})
 .then(()=>load());
}

load();
</script>
</body>
</html>
