-- 1. INNER JOIN
SELECT e.name, d.name AS department
FROM employees e
INNER JOIN departments d ON e.dept_id = d.id;

-- 2. LEFT JOIN
SELECT d.name, e.name
FROM departments d
LEFT JOIN employees e ON d.id = e.dept_id;

-- 3. GROUP BY with COUNT
SELECT d.name, COUNT(e.id) AS total_employees
FROM departments d
LEFT JOIN employees e ON d.id = e.dept_id
GROUP BY d.name;

-- 4. GROUP BY with AVG
SELECT d.name, AVG(e.salary) AS avg_salary
FROM departments d
JOIN employees e ON d.id = e.dept_id
GROUP BY d.name;

-- 5. Subquery – employees earning above average
SELECT name, salary
FROM employees
WHERE salary > (SELECT AVG(salary) FROM employees);

-- 6. Subquery with JOIN
SELECT name
FROM employees
WHERE dept_id = (
 SELECT id FROM departments WHERE name='IT'
);
