<?php
require_once "../config/db.php";

$action = $_POST['action'] ?? '';

if($action === 'register'){
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    if(!filter_var($email,FILTER_VALIDATE_EMAIL)){
        echo json_encode(["status"=>false,"msg"=>"Invalid email"]); exit;
    }

    $hash = password_hash($password, PASSWORD_DEFAULT);

    try{
        $stmt = $pdo->prepare("INSERT INTO users (email,password) VALUES (?,?)");
        $stmt->execute([$email,$hash]);
        echo json_encode(["status"=>true,"msg"=>"Registered"]);
    } catch(PDOException $e){
        echo json_encode(["status"=>false,"msg"=>"Email exists"]);
    }
    exit;
}

if($action === 'login'){
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email=?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if($user && password_verify($password,$user['password'])){
        $_SESSION['uid']=$user['id'];
        echo json_encode(["status"=>true,"msg"=>"Login success"]);
    } else {
        echo json_encode(["status"=>false,"msg"=>"Invalid credentials"]);
    }
}
