<?php
require_once "../config/db.php";

$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$message = trim($_POST['message'] ?? '');

$errors = [];

// Server-side validation
if($name === '') $errors['name'] = "Name is required";
if(!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors['email'] = "Valid email required";
if(!preg_match('/^[0-9]{10}$/',$phone)) $errors['phone'] = "Valid 10-digit phone required";
if(strlen($message) < 10) $errors['message'] = "Message must be at least 10 characters";

if(!empty($errors)){
    echo json_encode(["status"=>false,"errors"=>$errors]);
    exit;
}

$stmt = $pdo->prepare(
    "INSERT INTO contacts (name,email,phone,message) VALUES (?,?,?,?)"
);
$stmt->execute([$name,$email,$phone,$message]);

echo json_encode(["status"=>true,"message"=>"Form submitted successfully"]);
